/*
 * Decompiled with CFR 0.152.
 */
package com.chrisgli.gemsnjewels.items;

import com.chrisgli.gemsnjewels.Main;
import com.chrisgli.gemsnjewels.config.GemsNJewelsConfig;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class GemSetSword
extends SwordItem {
    private final float totalBaseDamage;
    private final float baseAttackSpeed;

    public GemSetSword() {
        super((Tier)Tiers.DIAMOND, 3, -2.4f, new Item.Properties().m_41491_(Main.TOOL_TAB));
        this.totalBaseDamage = 3.0f + Tiers.DIAMOND.m_6631_();
        this.baseAttackSpeed = -2.4f;
    }

    public GemSetSword(Tier tier, int attackDamageIn, float attackSpeedIn, Item.Properties p_i48460_4_) {
        super(tier, attackDamageIn, attackSpeedIn, p_i48460_4_);
        this.totalBaseDamage = (float)attackDamageIn + tier.m_6631_();
        this.baseAttackSpeed = attackSpeedIn;
    }

    public float getTotalBaseDamage() {
        return this.totalBaseDamage;
    }

    public float getBaseAttackSpeed() {
        return this.baseAttackSpeed;
    }

    public int getLevelProgress(ItemStack stack) {
        CompoundTag nbt;
        int killProgress = 0;
        if (stack.m_41782_() && (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() > 0 && (nbt = stack.m_41783_()).m_128441_("Kills")) {
            killProgress = nbt.m_128451_("Kills") % (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() / ((Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() / 10);
        }
        return killProgress;
    }

    public int getCurrentLevel(ItemStack stack) {
        CompoundTag nbt;
        int level = 0;
        if (stack.m_41782_() && (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get() > 0 && (nbt = stack.m_41783_()).m_128441_("Kills")) {
            level = nbt.m_128451_("Kills") / (Integer)GemsNJewelsConfig.COMMON.swordKillsPerLevel.get();
        }
        return level;
    }

    public String getEffectType(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Effect")) {
            String effectName = stack.m_41783_().m_128461_("Effect");
            return effectName;
        }
        return null;
    }

    public void purifyPotionEffects(LivingEntity livingEntity) {
        if (!livingEntity.f_19853_.f_46443_) {
            ArrayList<MobEffect> effectsToRemove = new ArrayList<MobEffect>();
            for (MobEffectInstance effect : livingEntity.m_21220_()) {
                if (effect.m_19544_().m_19486_()) continue;
                effectsToRemove.add(effect.m_19544_());
            }
            for (MobEffect e : effectsToRemove) {
                livingEntity.m_21195_(e);
            }
        }
    }

    public boolean m_5812_(ItemStack stack) {
        return super.m_5812_(stack) || stack.m_41782_() && stack.m_41783_().m_128441_("Effect");
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (stack.m_41782_()) {
            CompoundTag nbt = stack.m_41783_();
            if (nbt.m_128441_("Effect")) {
                String effectType;
                MobEffect ringEffect = MobEffects.f_19621_;
                switch (effectType = this.getEffectType(stack)) {
                    case "Speed": {
                        ringEffect = MobEffects.f_19596_;
                        break;
                    }
                    case "Slowness": {
                        ringEffect = MobEffects.f_19597_;
                        break;
                    }
                    case "Leaping": {
                        ringEffect = MobEffects.f_19603_;
                        break;
                    }
                    case "Strength": {
                        ringEffect = MobEffects.f_19600_;
                        break;
                    }
                    case "Healing": {
                        ringEffect = MobEffects.f_19601_;
                        break;
                    }
                    case "Harming": {
                        ringEffect = MobEffects.f_19602_;
                        break;
                    }
                    case "Poison": {
                        ringEffect = MobEffects.f_19614_;
                        break;
                    }
                    case "Regeneration": {
                        ringEffect = MobEffects.f_19605_;
                        break;
                    }
                    case "FireResistance": {
                        ringEffect = MobEffects.f_19607_;
                        break;
                    }
                    case "WaterBreathing": {
                        ringEffect = MobEffects.f_19608_;
                        break;
                    }
                    case "NightVision": {
                        ringEffect = MobEffects.f_19611_;
                        break;
                    }
                    case "Invisibility": {
                        ringEffect = MobEffects.f_19609_;
                        break;
                    }
                    case "Resistance": {
                        ringEffect = MobEffects.f_19606_;
                        break;
                    }
                    case "SlowFalling": {
                        ringEffect = MobEffects.f_19591_;
                        break;
                    }
                    case "Weakness": {
                        ringEffect = MobEffects.f_19613_;
                        break;
                    }
                    case "Haste": {
                        ringEffect = MobEffects.f_19598_;
                        break;
                    }
                    case "InstantHealth": {
                        ringEffect = MobEffects.f_19601_;
                        break;
                    }
                    case "Absorption": {
                        ringEffect = MobEffects.f_19617_;
                        break;
                    }
                    case "Luck": {
                        ringEffect = MobEffects.f_19621_;
                        break;
                    }
                    case "SpellBreaking": {
                        if (attacker.f_19853_.f_46443_) break;
                        target.curePotionEffects(new ItemStack((ItemLike)Items.f_42455_, 1));
                        break;
                    }
                    case "Purification": {
                        this.purifyPotionEffects(target);
                        break;
                    }
                    case "Levitation": {
                        ringEffect = MobEffects.f_19620_;
                        break;
                    }
                    case "HealthBoost": {
                        ringEffect = MobEffects.f_19616_;
                        break;
                    }
                    case "Saturation": {
                        ringEffect = MobEffects.f_19618_;
                    }
                }
                if (!(effectType == null || effectType.equals("SpellBreaking") && effectType.equals("Purification"))) {
                    int pastDurration = 0;
                    if (!target.m_21220_().isEmpty()) {
                        // empty if block
                    }
                    if (ringEffect.m_8093_()) {
                        ringEffect.m_19461_((Entity)target, (Entity)target, target, 0, 1.0);
                    } else {
                        target.m_7292_(new MobEffectInstance(ringEffect, pastDurration + 200, 0, true, true));
                    }
                }
            }
            if (nbt.m_128441_("Kills") && ((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                int level = this.getCurrentLevel(stack);
                int randomChance = attacker.f_19853_.f_46441_.nextInt(2);
                if (level >= 7 && randomChance == 1) {
                    return true;
                }
            }
        }
        stack.m_41622_(1, attacker, p_220045_0_ -> p_220045_0_.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        String effectType = this.getEffectType(stack);
        if (this.getEffectType(stack) != null && this.m_5812_(stack)) {
            String charmText = "\u00a75Charm: ";
            String curseText = "\u00a7cCurse: ";
            switch (effectType) {
                case "Speed": {
                    tooltip.add((Component)new TextComponent(charmText + "Speed"));
                    break;
                }
                case "Slowness": {
                    tooltip.add((Component)new TextComponent(curseText + "Slowness"));
                    break;
                }
                case "Leaping": {
                    tooltip.add((Component)new TextComponent(charmText + "Leaping"));
                    break;
                }
                case "Strength": {
                    tooltip.add((Component)new TextComponent(charmText + "Strength"));
                    break;
                }
                case "Healing": {
                    tooltip.add((Component)new TextComponent(charmText + "Healing"));
                    break;
                }
                case "Harming": {
                    tooltip.add((Component)new TextComponent(curseText + "Harming"));
                    break;
                }
                case "Poison": {
                    tooltip.add((Component)new TextComponent(curseText + "Poison"));
                    break;
                }
                case "Regeneration": {
                    tooltip.add((Component)new TextComponent(charmText + "Regeneration"));
                    break;
                }
                case "FireResistance": {
                    tooltip.add((Component)new TextComponent(charmText + "Fire Resistance"));
                    break;
                }
                case "WaterBreathing": {
                    tooltip.add((Component)new TextComponent(charmText + "Water Breathing"));
                    break;
                }
                case "NightVision": {
                    tooltip.add((Component)new TextComponent(charmText + "Night Vision"));
                    break;
                }
                case "Invisibility": {
                    tooltip.add((Component)new TextComponent(charmText + "Invisibility"));
                    break;
                }
                case "Resistance": {
                    tooltip.add((Component)new TextComponent(charmText + "Resistance"));
                    break;
                }
                case "SlowFalling": {
                    tooltip.add((Component)new TextComponent(charmText + "Slow Falling"));
                    break;
                }
                case "Weakness": {
                    tooltip.add((Component)new TextComponent(curseText + "Weakness"));
                    break;
                }
                case "Haste": {
                    tooltip.add((Component)new TextComponent(charmText + "Haste"));
                    break;
                }
                case "InstantHealth": {
                    tooltip.add((Component)new TextComponent(charmText + "Instant Health"));
                    break;
                }
                case "Absorption": {
                    tooltip.add((Component)new TextComponent(charmText + "Absorption"));
                    break;
                }
                case "Luck": {
                    tooltip.add((Component)new TextComponent(charmText + "Luck"));
                    break;
                }
                case "SpellBreaking": {
                    tooltip.add((Component)new TextComponent(charmText + "Spell Breaking"));
                    break;
                }
                case "Purification": {
                    tooltip.add((Component)new TextComponent(charmText + "Purification"));
                    break;
                }
                case "Levitation": {
                    tooltip.add((Component)new TextComponent(curseText + "Levitation"));
                    break;
                }
                case "HealthBoost": {
                    tooltip.add((Component)new TextComponent(charmText + "Health Boost"));
                    break;
                }
                case "Saturation": {
                    tooltip.add((Component)new TextComponent(charmText + "Saturation"));
                }
            }
        }
        if (stack.m_41782_() && stack.m_41783_().m_128441_("Kills")) {
            int i;
            int killCount = stack.m_41783_().m_128451_("Kills");
            int levelProgress = this.getLevelProgress(stack);
            int currentLevel = this.getCurrentLevel(stack);
            String kills = "\u00a7e" + Integer.toString(killCount);
            String level = "Mastery Lvl: " + currentLevel;
            level = currentLevel < 5 ? level + " \u00a77Novice" : (currentLevel < 10 ? level + " \u00a7aAdept" : (currentLevel < 20 ? level + " \u00a7bHeroic" : (currentLevel < 30 ? level + " \u00a7dMaster" : (currentLevel < 100 ? level + " \u00a7eLegendary" : level + " \u00a76Mythic"))));
            Object progression = "|\u00a7a";
            for (i = 0; i < levelProgress; ++i) {
                progression = (String)progression + "=";
            }
            progression = (String)progression + "\u00a77";
            for (i = levelProgress; i < 10; ++i) {
                progression = (String)progression + "-";
            }
            progression = (String)progression + "\u00a7f|";
            TextComponent slain = new TextComponent("Mobs Slain: " + kills);
            TextComponent levelText = new TextComponent(level);
            TextComponent progText = new TextComponent((String)progression);
            tooltip.add((Component)slain);
            if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((Component)levelText);
                tooltip.add((Component)progText);
                tooltip.add((Component)new TextComponent("\u00a75-Gains bonus attack speed per level"));
                if (currentLevel >= 3) {
                    tooltip.add((Component)new TextComponent("\u00a75-Bleeds experience from mobs"));
                }
                if (currentLevel >= 7) {
                    tooltip.add((Component)new TextComponent("\u00a75-Resists tool damage"));
                }
            } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
                tooltip.add((Component)new TextComponent("\u00a75Hold [Shift] for mastery details"));
            }
        } else if (((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            tooltip.add((Component)new TextComponent("\u00a77Gains perks from slaying mobs"));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot != EquipmentSlot.MAINHAND || !((Boolean)GemsNJewelsConfig.COMMON.toolLevelingEnabled.get()).booleanValue()) {
            return super.getAttributeModifiers(equipmentSlot, stack);
        }
        float attackSpeedBonus = -1.0f * this.getBaseAttackSpeed();
        int currentLevel = this.getCurrentLevel(stack);
        attackSpeedBonus = attackSpeedBonus * (float)currentLevel / 20.0f;
        attackSpeedBonus = Math.min(1024.0f, attackSpeedBonus);
        multimap.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)this.getTotalBaseDamage(), AttributeModifier.Operation.ADDITION));
        multimap.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getBaseAttackSpeed() + (double)attackSpeedBonus, AttributeModifier.Operation.ADDITION));
        return multimap;
    }
}

